
'''
Sample script to submit through dockerhub (name:tag)
'''

import datetime
import sys
import time

import requests

##########
TEAM  = 'test'
TOKEN = '287c0683c08e9d6c55a5a6d4852c35ef8b7d6a0c98bc990e0b33ab00'
STAGE = '2025'

IMAGE = 'xfuren/icts2023-sample:1126'
##########

API_URL = 'https://icts.top/api/'

def main(image):


    url = API_URL+'submit/'

    data = {
        'team': TEAM, 
        'token': TOKEN, 
        'stage': STAGE,

        'image': image,
    }

    print(datetime.datetime.now(), 'submitting', data['image'])
    response = requests.post(url, data=data)
    print(datetime.datetime.now(), response.content)

    id = response.json()['id']
    url = API_URL+'query/'+id

    secs = 1
    while True:
        time.sleep(secs)
        response = requests.get(url)
        print(datetime.datetime.now(), response.content)
        if response.json()['status'] != 'P':
            break
        secs = min(60, secs * 2)

if __name__ == '__main__':
    if len(sys.argv) > 1:
        image = sys.argv[1]
    else:
        image = IMAGE
    main(image)
